#ifndef _SIMPLEXPROPERTY_H_
#define _SIMPLEXPROPERTY_H_

#include <GSTenums.h>
#include <string>

namespace GST
{
namespace Geometry
{

class GST_API_EXPORT SimplexProperty
{
public:
	typedef PropertyTypes PropertyType;
	typedef PropertyAlignments PropertyAlignment;

	virtual ~SimplexProperty()
	{
	}

	///@name getter and setter
	//@{
	virtual std::string getName() const = 0;
	virtual void setName(const std::string &name) = 0;
	virtual PropertyType getType() const = 0;
	virtual int getDimension() const = 0;
	virtual PropertyAlignment getAlignment() const = 0;
	virtual std::string getTypeStr() const
	{
		switch(this->getType())
		{
		case TypeBool:
			return "bool";
			break;
		case TypeInt:
			return "int";
			break;
		case TypeLong:
			return "long";
			break;
		case TypeFloat:
			return "float";
			break;
		case TypeDouble:
			return "double";
			break;
		case TypeText:
			return "text";
			break;
		case TypeVecFloat:
			return "float vector";
			break;
		default:
			return "unkown";
			break;
		}
	}
	//@}
};
/**
 * Returns the property type encoded as string for property description
 * serialization.
 *
 * @see StreamableGeometry::serializeSimplexPropertyDescription
 */
GST_API_EXPORT std::string getPropertyTypeStrForDesc(DataType type);

} // namespace Geometry
} // namespace GST

#endif //_SIMPLEXPROPERTY_H_
